# Backend API Documentation

## API Base URL
```
https://your-domain.com/backend/api
```

## Endpoints

### 1. Get Locations
**GET** `/locations.php`

Returns all active locations.

**Response:**
```json
{
  "success": true,
  "message": "Locations retrieved successfully",
  "data": [
    {
      "id": 1,
      "name": "Dhaka",
      "district": "Dhaka",
      "latitude": "23.8103",
      "longitude": "90.4125",
      "is_active": 1
    }
  ]
}
```

### 2. Get Prayer Times
**GET** `/prayer-times.php?location_id=1&date=2026-03-01`

Returns prayer times for a specific location and date.

**Parameters:**
- `location_id` (required): Location ID
- `date` (required): Date in YYYY-MM-DD format

**Response:**
```json
{
  "success": true,
  "data": {
    "id": 1,
    "location_id": 1,
    "date": "2026-03-01",
    "fajr": "04:30",
    "sunrise": "06:00",
    "dhuhr": "12:15",
    "asr": "15:30",
    "maghrib": "18:00",
    "isha": "19:30",
    "sehri_end": "04:25",
    "iftar": "18:05",
    "ramadan_day": 1
  }
}
```

### 3. Get Prayer Times Range
**GET** `/prayer-times.php?location_id=1&start_date=2026-03-01&end_date=2026-03-30`

Returns prayer times for a date range.

**Parameters:**
- `location_id` (required): Location ID
- `start_date` (required): Start date in YYYY-MM-DD format
- `end_date` (required): End date in YYYY-MM-DD format

### 4. Get Ramadan Schedule
**GET** `/ramadan-schedule.php?location_id=1`

Returns full Ramadan schedule for a location.

**Response:**
```json
{
  "success": true,
  "data": [
    {
      "day": 1,
      "date": "2026-03-01",
      "sehri_end": "04:25",
      "iftar": "18:05",
      "special_note": null
    }
  ]
}
```

### 5. Get Islamic Content
**GET** `/islamic-content.php`
**GET** `/islamic-content.php?type=niyat`

Returns Islamic content, optionally filtered by type.

**Parameters:**
- `type` (optional): Content type (niyat, sehri_dua, iftar_dua, masala)

### 6. Get Notifications
**GET** `/notifications.php`

Returns active notifications.

### 7. Get Ads Configuration
**GET** `/ads-config.php`

Returns AdMob configuration.

## Admin Panel

Access the admin panel at: `/backend/admin/login.php`

### Features:
- Manage locations
- Manage prayer times
- Manage Islamic content
- Manage notifications
- Configure ads

### Default Credentials:
- Username: `admin`
- Password: `admin123`

**⚠️ Change the default password immediately!**

## Database Schema

See `database/schema.sql` for complete database structure.

## Seed Data (for Locations, Prayer Times, Islamic Content)

After running `schema.sql`, run the seed file so the app has data to show:

```bash
mysql -u root -p ramadan_app_db < database/seed_data.sql
```

Or in PHPMyAdmin: open `database/seed_data.sql`, copy its contents, and run in the SQL tab.

This inserts:
- **Prayer times** for Dhaka (location_id=1): Jan 2026 (for testing) and Ramadan 2026 (Feb 18 – Mar 19).
- **Prayer times** for all other locations (2–10) by copying from Dhaka, so every location has data.
- **Islamic content**: sample নিয়ত, সেহরির দোয়া, ইফতারের দোয়া, মাসআলা.

**If you already ran an older seed that only had Dhaka**, backfill other locations:

```bash
mysql -u root -p ramadan_app_db < database/backfill_prayer_times_all_locations.sql
```

For location-specific times, use Admin → **Generate Prayer Times** (requires lat/long on locations).

## Security

- All API endpoints use prepared statements (SQL injection protection)
- CORS is enabled for Flutter app
- Admin panel requires authentication
- Passwords are hashed using bcrypt

## Error Handling

All endpoints return JSON with this structure:
```json
{
  "success": false,
  "message": "Error message here"
}
```

HTTP status codes:
- 200: Success
- 400: Bad Request
- 404: Not Found
- 500: Server Error
