<?php
session_start();
require_once __DIR__ . '/../config/database.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$pdo = getDBConnection();
$message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Update or insert ads config
    $stmt = $pdo->prepare("
        UPDATE ads_config SET
            show_banner_ads = ?,
            show_interstitial_ads = ?,
            android_banner_ad_id = ?,
            android_interstitial_ad_id = ?,
            ios_banner_ad_id = ?,
            ios_interstitial_ad_id = ?,
            interstitial_ad_interval = ?
        WHERE id = (SELECT id FROM (SELECT id FROM ads_config LIMIT 1) AS tmp)
    ");
    
    try {
        $stmt->execute([
            isset($_POST['show_banner_ads']) ? 1 : 0,
            isset($_POST['show_interstitial_ads']) ? 1 : 0,
            $_POST['android_banner_ad_id'] ?: null,
            $_POST['android_interstitial_ad_id'] ?: null,
            $_POST['ios_banner_ad_id'] ?: null,
            $_POST['ios_interstitial_ad_id'] ?: null,
            $_POST['interstitial_ad_interval'] ?? 3,
        ]);
        $message = '<div style="background: #dfd; color: #060; padding: 10px; border-radius: 6px; margin-bottom: 20px;">Ads configuration updated successfully!</div>';
    } catch (Exception $e) {
        $message = '<div style="background: #fdd; color: #600; padding: 10px; border-radius: 6px; margin-bottom: 20px;">Error: ' . htmlspecialchars($e->getMessage()) . '</div>';
    }
}

// Get current config
$config = $pdo->query("SELECT * FROM ads_config LIMIT 1")->fetch();
if (!$config) {
    // Create default config
    $pdo->exec("INSERT INTO ads_config (show_banner_ads, show_interstitial_ads) VALUES (0, 0)");
    $config = $pdo->query("SELECT * FROM ads_config LIMIT 1")->fetch();
}
?>
<?php include 'header.php'; ?>

<div class="container">
    <h2>Ads Configuration</h2>
    
    <?= $message ?>
    
    <div class="section">
        <form method="POST" style="max-width: 800px;">
            <div class="form-group">
                <label>
                    <input type="checkbox" name="show_banner_ads" <?= $config['show_banner_ads'] ? 'checked' : '' ?>>
                    Show Banner Ads
                </label>
            </div>
            <div class="form-group">
                <label>
                    <input type="checkbox" name="show_interstitial_ads" <?= $config['show_interstitial_ads'] ? 'checked' : '' ?>>
                    Show Interstitial Ads
                </label>
            </div>
            
            <h3 style="margin-top: 30px; margin-bottom: 15px;">Android Ad IDs</h3>
            <div class="form-group">
                <label>Android Banner Ad ID</label>
                <input type="text" name="android_banner_ad_id" value="<?= htmlspecialchars($config['android_banner_ad_id'] ?? '') ?>" placeholder="ca-app-pub-xxxxx/xxxxx">
            </div>
            <div class="form-group">
                <label>Android Interstitial Ad ID</label>
                <input type="text" name="android_interstitial_ad_id" value="<?= htmlspecialchars($config['android_interstitial_ad_id'] ?? '') ?>" placeholder="ca-app-pub-xxxxx/xxxxx">
            </div>
            
            <h3 style="margin-top: 30px; margin-bottom: 15px;">iOS Ad IDs</h3>
            <div class="form-group">
                <label>iOS Banner Ad ID</label>
                <input type="text" name="ios_banner_ad_id" value="<?= htmlspecialchars($config['ios_banner_ad_id'] ?? '') ?>" placeholder="ca-app-pub-xxxxx/xxxxx">
            </div>
            <div class="form-group">
                <label>iOS Interstitial Ad ID</label>
                <input type="text" name="ios_interstitial_ad_id" value="<?= htmlspecialchars($config['ios_interstitial_ad_id'] ?? '') ?>" placeholder="ca-app-pub-xxxxx/xxxxx">
            </div>
            
            <div class="form-group">
                <label>Interstitial Ad Interval (show after N screen views)</label>
                <input type="number" name="interstitial_ad_interval" value="<?= htmlspecialchars($config['interstitial_ad_interval'] ?? 3) ?>" min="1" max="10">
            </div>
            
            <button type="submit" class="btn">Save Configuration</button>
        </form>
    </div>
</div>

<style>
    .form-group { margin-bottom: 15px; }
    .form-group label { display: block; margin-bottom: 5px; font-weight: 500; }
    .form-group input[type="text"], .form-group input[type="number"] { 
        width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px; 
    }
</style>
</body>
</html>
