<?php
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Ramadan App</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f5f5f5;
        }
        .header {
            background: linear-gradient(135deg, #2D5016 0%, #4A7C2A 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .nav {
            background: white;
            padding: 15px 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .nav a {
            display: inline-block;
            padding: 10px 20px;
            margin-right: 10px;
            background: #2D5016;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            transition: background 0.3s;
        }
        .nav a:hover { background: #4A7C2A; }
        .nav a.logout {
            background: #c33;
            float: right;
        }
        .nav a.logout:hover { background: #a22; }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        .section {
            background: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .section h2, .section h3 {
            color: #2D5016;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #e0e0e0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #e0e0e0;
        }
        th {
            background: #f5f5f5;
            font-weight: 600;
            color: #333;
        }
        .btn {
            padding: 10px 20px;
            background: #2D5016;
            color: white;
            text-decoration: none;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
        }
        .btn:hover { background: #4A7C2A; }
    </style>
</head>
<body>
    <div class="header">
        <h1>🕌 Ramadan App Admin Dashboard</h1>
        <p>Welcome, <?= htmlspecialchars($_SESSION['admin_username']) ?></p>
    </div>
    
    <div class="nav">
        <a href="index.php">Dashboard</a>
        <a href="locations.php">Locations</a>
        <a href="prayer-times.php">Prayer Times</a>
        <a href="generate-prayer-times.php" style="background: #1565c0;">⚡ Generate Times</a>
        <a href="ramadan-schedule.php">Ramadan Schedule</a>
        <a href="islamic-content.php">Islamic Content</a>
        <a href="notifications.php">Notifications</a>
        <a href="ads-config.php">Ads Config</a>
        <a href="logout.php" class="logout">Logout</a>
    </div>
