<?php
session_start();
require_once __DIR__ . '/../config/database.php';

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

$pdo = getDBConnection();

// Get statistics
$stats = [
    'locations' => $pdo->query("SELECT COUNT(*) FROM locations WHERE is_active = 1")->fetchColumn(),
    'prayer_times' => $pdo->query("SELECT COUNT(*) FROM prayer_times")->fetchColumn(),
    'islamic_content' => $pdo->query("SELECT COUNT(*) FROM islamic_content WHERE is_active = 1")->fetchColumn(),
    'surahs' => $pdo->query("SELECT COUNT(*) FROM surahs WHERE is_active = 1")->fetchColumn(),
    'notifications' => $pdo->query("SELECT COUNT(*) FROM notifications WHERE is_active = 1")->fetchColumn(),
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Ramadan App</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f5f5f5;
        }
        .header {
            background: linear-gradient(135deg, #2D5016 0%, #4A7C2A 100%);
            color: white;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header h1 { margin-bottom: 10px; }
        .header p { opacity: 0.9; }
        .nav {
            background: white;
            padding: 15px 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .nav a {
            display: inline-block;
            padding: 10px 20px;
            margin-right: 10px;
            background: #2D5016;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            transition: background 0.3s;
        }
        .nav a:hover { background: #4A7C2A; }
        .nav a.logout {
            background: #c33;
            float: right;
        }
        .nav a.logout:hover { background: #a22; }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .stat-card h3 {
            color: #666;
            font-size: 14px;
            margin-bottom: 10px;
            text-transform: uppercase;
        }
        .stat-card .number {
            font-size: 36px;
            font-weight: bold;
            color: #2D5016;
        }
        .section {
            background: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .section h2 {
            color: #2D5016;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #e0e0e0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #e0e0e0;
        }
        th {
            background: #f5f5f5;
            font-weight: 600;
            color: #333;
        }
        .btn {
            padding: 8px 16px;
            background: #2D5016;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            display: inline-block;
            font-size: 14px;
        }
        .btn:hover { background: #4A7C2A; }
        .btn-small {
            padding: 4px 8px;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>🕌 Ramadan App Admin Dashboard</h1>
        <p>Welcome, <?= htmlspecialchars($_SESSION['admin_username']) ?></p>
    </div>
    
    <div class="nav">
        <a href="index.php">Dashboard</a>
        <a href="locations.php">Locations</a>
        <a href="prayer-times.php">Prayer Times</a>
        <a href="ramadan-schedule.php">Ramadan Schedule</a>
        <a href="islamic-content.php">Islamic Content</a>
        <a href="surahs.php">Surahs</a>
        <a href="notifications.php">Notifications</a>
        <a href="ads-config.php">Ads Config</a>
        <a href="logout.php" class="logout">Logout</a>
    </div>
    
    <div class="container">
        <div class="stats">
            <div class="stat-card">
                <h3>Active Locations</h3>
                <div class="number"><?= $stats['locations'] ?></div>
            </div>
            <div class="stat-card">
                <h3>Prayer Times</h3>
                <div class="number"><?= $stats['prayer_times'] ?></div>
            </div>
            <div class="stat-card">
                <h3>Islamic Content</h3>
                <div class="number"><?= $stats['islamic_content'] ?></div>
            </div>
            <div class="stat-card">
                <h3>Active Surahs</h3>
                <div class="number"><?= $stats['surahs'] ?></div>
            </div>
            <div class="stat-card">
                <h3>Active Notifications</h3>
                <div class="number"><?= $stats['notifications'] ?></div>
            </div>
        </div>
        
        <div class="section">
            <h2>Quick Actions</h2>
            <p><a href="locations.php" class="btn">Manage Locations</a></p>
            <p style="margin-top: 10px;"><a href="prayer-times.php" class="btn">Manage Prayer Times</a></p>
            <p style="margin-top: 10px;"><a href="ramadan-schedule.php" class="btn">Manage Ramadan Schedule</a></p>
            <p style="margin-top: 10px;"><a href="islamic-content.php" class="btn">Manage Islamic Content</a></p>
            <p style="margin-top: 10px;"><a href="surahs.php" class="btn">Manage Surahs (Quran Audio)</a></p>
        </div>
    </div>
</body>
</html>
