<?php
/**
 * Ads Configuration API Endpoint
 * GET /api/ads-config.php - Get ads configuration
 */

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/response.php';
require_once __DIR__ . '/../includes/cors.php';

try {
    $pdo = getDBConnection();
    
    $stmt = $pdo->prepare("
        SELECT show_banner_ads, show_interstitial_ads,
               android_banner_ad_id, android_interstitial_ad_id,
               ios_banner_ad_id, ios_interstitial_ad_id,
               interstitial_ad_interval
        FROM ads_config
        ORDER BY id DESC
        LIMIT 1
    ");
    
    $stmt->execute();
    $config = $stmt->fetch();
    
    if (!$config) {
        // Return default config
        $config = [
            'show_banner_ads' => 0,
            'show_interstitial_ads' => 0,
            'android_banner_ad_id' => null,
            'android_interstitial_ad_id' => null,
            'ios_banner_ad_id' => null,
            'ios_interstitial_ad_id' => null,
            'interstitial_ad_interval' => 3,
        ];
    }
    
    sendSuccess($config, 'Ads configuration retrieved successfully');
    
} catch (Exception $e) {
    sendError('Failed to retrieve ads configuration: ' . $e->getMessage(), 500);
}
?>
