<?php
/**
 * Islamic Content API Endpoint
 * GET /api/islamic-content.php - Get all content
 * GET /api/islamic-content.php?type=niyat - Get content by type
 */

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/response.php';
require_once __DIR__ . '/../includes/cors.php';

try {
    $pdo = getDBConnection();
    $type = $_GET['type'] ?? null;
    
    if ($type) {
        $stmt = $pdo->prepare("
            SELECT id, type, title, content, arabic_text, transliteration, translation,
                   display_order, is_active
            FROM islamic_content
            WHERE type = ? AND is_active = 1
            ORDER BY display_order ASC, id ASC
        ");
        
        $stmt->execute([$type]);
    } else {
        $stmt = $pdo->prepare("
            SELECT id, type, title, content, arabic_text, transliteration, translation,
                   display_order, is_active
            FROM islamic_content
            WHERE is_active = 1
            ORDER BY type, display_order ASC, id ASC
        ");
        
        $stmt->execute();
    }
    
    $content = $stmt->fetchAll();
    
    sendSuccess($content, 'Islamic content retrieved successfully');
    
} catch (Exception $e) {
    sendError('Failed to retrieve Islamic content: ' . $e->getMessage(), 500);
}
?>
