<?php
/**
 * Locations API Endpoint
 * GET /api/locations.php - Get all active locations
 */

require_once __DIR__ . '/../includes/cors.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/response.php';

try {
    $pdo = getDBConnection();
    
    $stmt = $pdo->prepare("
        SELECT id, name, district, latitude, longitude, is_active
        FROM locations
        WHERE is_active = 1
        ORDER BY district, name
    ");
    
    $stmt->execute();
    $locations = $stmt->fetchAll();
    
    sendSuccess($locations, 'Locations retrieved successfully');
    
} catch (Exception $e) {
    sendError('Failed to retrieve locations: ' . $e->getMessage(), 500);
}
?>
