<?php
/**
 * Notification Sent Marker API
 * Mark instant notifications as sent to prevent re-delivery
 */

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/response.php';
require_once __DIR__ . '/../includes/cors.php';

try {
    $pdo = getDBConnection();
    
    // POST request থেকে notification ID পান
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['notification_id'])) {
        sendError('notification_id প্রয়োজন', 400);
        exit;
    }
    
    $notificationId = intval($input['notification_id']);
    
    // শুধুমাত্র তাৎক্ষণিক নোটিফিকেশন (is_scheduled = 0) কে চিহ্নিত করুন
    $stmt = $pdo->prepare("
        UPDATE notifications 
        SET last_sent_at = NOW()
        WHERE id = ? 
        AND is_scheduled = 0
    ");
    
    $stmt->execute([$notificationId]);
    
    if ($stmt->rowCount() > 0) {
        sendSuccess(['notification_id' => $notificationId], 'নোটিফিকেশন পাঠানো হিসেবে চিহ্নিত করা হয়েছে');
    } else {
        sendError('নোটিফিকেশন পাওয়া যায়নি বা এটি scheduled', 400);
    }
    
} catch (Exception $e) {
    sendError('ত্রুটি: ' . $e->getMessage(), 500);
}
?>
