<?php
/**
 * Ramadan Schedule API Endpoint
 * GET /api/ramadan-schedule.php?location_id=1
 * location_id: optional, defaults to 1 (Dhaka) when missing
 */

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../includes/response.php';
require_once __DIR__ . '/../includes/cors.php';

try {
    $pdo = getDBConnection();

    // Accept location_id or locationId (camelCase); default to 1 when missing or invalid
    $locationId = (int) ($_GET['location_id'] ?? $_GET['locationId'] ?? 1);
    if ($locationId <= 0) {
        $locationId = 1;
    }
    
    // First verify location exists
    $locationCheck = $pdo->prepare("SELECT id, name FROM locations WHERE id = ? AND is_active = 1");
    $locationCheck->execute([$locationId]);
    $location = $locationCheck->fetch();
    
    if (!$location) {
        sendError('Location not found or inactive', 404);
        return;
    }
    
    $stmt = $pdo->prepare("
        SELECT ramadan_day as day,
               DATE_FORMAT(date, '%Y-%m-%d') as date,
               TIME_FORMAT(sehri_end, '%H:%i') as sehri_end,
               TIME_FORMAT(iftar, '%H:%i') as iftar,
               NULL as special_note
        FROM prayer_times
        WHERE location_id = ? AND ramadan_day > 0
        ORDER BY date ASC
    ");
    
    $stmt->execute([$locationId]);
    $schedule = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Return empty array if no data, not an error
    sendSuccess($schedule, 'Ramadan schedule retrieved successfully');
    
} catch (Exception $e) {
    sendError('Failed to retrieve Ramadan schedule: ' . $e->getMessage(), 500);
}
?>
