<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';

try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get only active surahs, ordered by display_order
    $stmt = $pdo->prepare("
        SELECT id, surah_name, surah_number, audio_url, description, display_order, is_active
        FROM surahs
        WHERE is_active = 1
        ORDER BY display_order ASC
    ");
    $stmt->execute();
    $surahs = $stmt->fetchAll(PDO::FETCH_ASSOC);

    http_response_code(200);
    echo json_encode([
        'success' => true,
        'message' => 'Surahs fetched successfully',
        'data' => $surahs
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Error fetching surahs: ' . $e->getMessage(),
        'data' => []
    ]);
}
?>
