-- Seed data for Ramadan App
-- Run AFTER schema.sql. Fills prayer_times (Dhaka, Ramadan 2026) and islamic_content.
-- Ramadan 2026 (1447 AH): approx 18 Feb – 19 Mar 2026

USE ramadan_app_db;

-- Prayer times for Dhaka (location_id=1)
-- Jan 2026: for testing "today" outside Ramadan
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day) VALUES
(1,'2026-01-20','05:20','06:35','12:10','15:25','17:50','19:05','05:25','17:50',0),
(1,'2026-01-21','05:20','06:35','12:10','15:26','17:51','19:06','05:25','17:51',0),
(1,'2026-01-22','05:19','06:34','12:10','15:26','17:52','19:06','05:24','17:52',0),
(1,'2026-01-23','05:19','06:34','12:11','15:27','17:52','19:07','05:24','17:52',0),
(1,'2026-01-24','05:18','06:33','12:11','15:28','17:53','19:08','05:23','17:53',0),
(1,'2026-01-25','05:18','06:33','12:11','15:28','17:54','19:08','05:23','17:54',0),
(1,'2026-01-26','05:17','06:32','12:11','15:29','17:55','19:09','05:22','17:55',0),
(1,'2026-01-27','05:17','06:32','12:11','15:29','17:55','19:10','05:22','17:55',0),
(1,'2026-01-28','05:16','06:31','12:12','15:30','17:56','19:10','05:21','17:56',0),
(1,'2026-01-29','05:16','06:31','12:12','15:30','17:57','19:11','05:21','17:57',0),
(1,'2026-01-30','05:15','06:30','12:12','15:31','17:58','19:12','05:20','17:58',0),
(1,'2026-01-31','05:15','06:30','12:12','15:31','17:58','19:12','05:20','17:58',0);

-- Ramadan 2026 (approx 18 Feb – 19 Mar 2026)
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day) VALUES
(1,'2026-02-18','04:52','06:08','12:12','15:32','18:12','19:28','04:57','18:12',1),
(1,'2026-02-19','04:51','06:07','12:12','15:33','18:13','19:29','04:56','18:13',2),
(1,'2026-02-20','04:50','06:06','12:12','15:33','18:13','19:29','04:55','18:13',3),
(1,'2026-02-21','04:49','06:05','12:12','15:34','18:14','19:30','04:54','18:14',4),
(1,'2026-02-22','04:48','06:04','12:12','15:34','18:15','19:30','04:53','18:15',5),
(1,'2026-02-23','04:47','06:03','12:12','15:35','18:15','19:31','04:52','18:15',6),
(1,'2026-02-24','04:46','06:02','12:11','15:35','18:16','19:31','04:51','18:16',7),
(1,'2026-02-25','04:45','06:01','12:11','15:36','18:16','19:32','04:50','18:16',8),
(1,'2026-02-26','04:44','06:00','12:11','15:36','18:17','19:32','04:49','18:17',9),
(1,'2026-02-27','04:43','05:59','12:11','15:37','18:18','19:33','04:48','18:18',10),
(1,'2026-02-28','04:42','05:58','12:11','15:37','18:18','19:33','04:47','18:18',11),
(1,'2026-03-01','04:41','05:57','12:11','15:38','18:19','19:34','04:46','18:19',12),
(1,'2026-03-02','04:40','05:56','12:10','15:38','18:19','19:34','04:45','18:19',13),
(1,'2026-03-03','04:39','05:55','12:10','15:39','18:20','19:35','04:44','18:20',14),
(1,'2026-03-04','04:38','05:54','12:10','15:39','18:20','19:35','04:43','18:20',15),
(1,'2026-03-05','04:37','05:53','12:10','15:40','18:21','19:36','04:42','18:21',16),
(1,'2026-03-06','04:36','05:52','12:10','15:40','18:22','19:36','04:41','18:22',17),
(1,'2026-03-07','04:35','05:51','12:09','15:41','18:22','19:37','04:40','18:22',18),
(1,'2026-03-08','04:34','05:50','12:09','15:41','18:23','19:37','04:39','18:23',19),
(1,'2026-03-09','04:33','05:49','12:09','15:42','18:23','19:38','04:38','18:23',20),
(1,'2026-03-10','04:32','05:48','12:09','15:42','18:24','19:38','04:37','18:24',21),
(1,'2026-03-11','04:31','05:47','12:08','15:43','18:24','19:39','04:36','18:24',22),
(1,'2026-03-12','04:30','05:46','12:08','15:43','18:25','19:39','04:35','18:25',23),
(1,'2026-03-13','04:29','05:45','12:08','15:44','18:25','19:40','04:34','18:25',24),
(1,'2026-03-14','04:28','05:44','12:08','15:44','18:26','19:40','04:33','18:26',25),
(1,'2026-03-15','04:27','05:43','12:07','15:45','18:26','19:41','04:32','18:26',26),
(1,'2026-03-16','04:26','05:42','12:07','15:45','18:27','19:41','04:31','18:27',27),
(1,'2026-03-17','04:25','05:41','12:07','15:46','18:27','19:42','04:30','18:27',28),
(1,'2026-03-18','04:24','05:40','12:06','15:46','18:28','19:42','04:29','18:28',29),
(1,'2026-03-19','04:23','05:39','12:06','15:47','18:28','19:43','04:28','18:28',30);

-- Islamic content (sample)
INSERT IGNORE INTO islamic_content (type, title, content, arabic_text, transliteration, translation, display_order) VALUES
('niyat','রোজার নিয়ত','রমজান মাসের ফরজ রোজা রাখার নিয়ত।','نَوَيْتُ أَنْ أَصُومَ غَدًا عَنْ أَدَاءِ فَرْضِ شَهْرِ رَمَضَانَ هذِهِ السَّنَةِ لِلّٰهِ تَعَالَى','নাওয়াইতু আন আছুমা গাদান্ আন আদায়ি ফারজি শাহরি রামাদ্বানা হাযিহিস্ সানতি লিল্লাহি তা'আলা।','হে আল্লাহ! আমি আপনার সন্তুষ্টির জন্য আগামীকাল রমজান মাসের ফরজ রোজা রাখার নিয়ত করছি।',1),
('sehri_dua','সেহরির দোয়া','সেহরি খাওয়ার পর পড়ার দোয়া।','وَبِصَوْمِ غَدٍ نَّوَيْتُ مِنْ شَهْرِ رَمَضَانَ','ওয়া বিছাওমি গাদিন্ নাওয়াইতু মিন শাহরি রামাদ্বান।','হে আল্লাহ! আমি রমজান মাসের আগামীকালের রোজা রাখার নিয়ত করছি।',1),
('iftar_dua','ইফতারের দোয়া','ইফতারের সময় পড়ার দোয়া।','اَللّٰهُمَّ اِنِّی لَکَ صُمْتُ وَبِکَ اٰمَنْتُ وَعَلَيْکَ تَوَکَّلْتُ وَعَلٰی رِزْقِکَ اَفْطَرْتُ','আল্লাহুম্মা ইন্নী লাকা ছুমতু ওয়া বিকা āমানতু ওয়া আলাইকা তাওয়াক্কালতু ওয়া আলা রিযকিকা আফতারতু।','হে আল্লাহ! আমি তোমারই জন্য রোজা রেখেছি, তোমার উপর ঈমান এনেছি, তোমার উপর ভরসা করেছি এবং তোমার দেয়া রিজিক দিয়ে ইফতার করছি।',1),
('masala','রমজান মাসআলা','রোজা ভঙ্গ হওয়ার কারণসমূহ: খাদ্য-পানীয় গ্রহণ, ইচ্ছাকৃত বমি, ঋতু ও প্রসব, সহবাস ইত্যাদি।','','','রোজা রাখা অবস্থায় কোনোরূপ খাদ্য বা পানীয় জাহিরভাবে (পেটে পৌঁছালে) গ্রহণ করলে রোজা ভঙ্গ হয়। ইচ্ছাকৃত বমি করলে রোজা ভঙে। ভুলবশত খাওয়া-দাওয়া করলে রোজা ভঙ্গ হয় না।',1);

-- Prayer times for other locations (2–10): same date ranges as Dhaka, using Dhaka times as base
-- Run "Generate Prayer Times" in admin for location-specific calculations. These ensure data exists for all locations.
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day)
SELECT 2, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day FROM prayer_times WHERE location_id = 1;
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day)
SELECT 3, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day FROM prayer_times WHERE location_id = 1;
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day)
SELECT 4, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day FROM prayer_times WHERE location_id = 1;
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day)
SELECT 5, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day FROM prayer_times WHERE location_id = 1;
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day)
SELECT 6, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day FROM prayer_times WHERE location_id = 1;
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day)
SELECT 7, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day FROM prayer_times WHERE location_id = 1;
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day)
SELECT 8, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day FROM prayer_times WHERE location_id = 1;
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day)
SELECT 9, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day FROM prayer_times WHERE location_id = 1;
INSERT IGNORE INTO prayer_times (location_id, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day)
SELECT 10, date, fajr, sunrise, dhuhr, asr, maghrib, isha, sehri_end, iftar, ramadan_day FROM prayer_times WHERE location_id = 1;
