<?php
/**
 * Response Helper Functions
 */

function sendResponse($success, $data = null, $message = '', $statusCode = 200) {
    http_response_code($statusCode);
    header('Content-Type: application/json; charset=utf-8');
    
    $response = [
        'success' => $success,
        'message' => $message,
    ];
    
    if ($data !== null) {
        $response['data'] = $data;
    }
    
    echo json_encode($response, JSON_UNESCAPED_UNICODE);
    exit;
}

function sendError($message, $statusCode = 400) {
    sendResponse(false, null, $message, $statusCode);
}

function sendSuccess($data = null, $message = 'Success') {
    sendResponse(true, $data, $message);
}
?>
